import os
import datetime

def main():
    # Récupère le répertoire courant
    current_dir = os.getcwd()
    folder_name = os.path.basename(current_dir)
    
    # Nom du fichier de sortie
    date_str = datetime.datetime.now().strftime("%Y%m%d_%H%M%S")
    output_filename = f"{folder_name}_{date_str}.txt"
    output_filepath = os.path.join(current_dir, output_filename)

    # Nom du script lui-même à exclure
    script_name = "compact_projet.py"
    script_path = os.path.join(current_dir, script_name)

    with open(output_filepath, 'w', encoding='utf-8') as output_file:
        for root, _, files in os.walk(current_dir):
            for file in files:
                file_path = os.path.join(root, file)

                # Sauter le fichier de sortie et le script lui-même
                if os.path.abspath(file_path) in [os.path.abspath(output_filepath), os.path.abspath(script_path)]:
                    continue

                output_file.write(f"\n/////***///// FILE: {file_path}\n")
                try:
                    with open(file_path, 'r', encoding='utf-8') as f:
                        content = f.read()
                    output_file.write(content)
                except Exception as e:
                    output_file.write(f"[Erreur de lecture: {e}]\n")

    print(f"Fichier généré : {output_filename}")

if __name__ == "__main__":
    main()
