<?php
// config/auth_middleware.php - Gestion des rôles et permissions

function getAuthenticatedUser() {
    // Récupérer le token depuis les headers
    $headers = getallheaders();
    $token = null;
    
    if (isset($headers['Authorization'])) {
        $auth = $headers['Authorization'];
        if (preg_match('/Bearer\s+(.*)$/i', $auth, $matches)) {
            $token = $matches[1];
        }
    }
    
    if (!$token) {
        return null;
    }
    
    // Décoder le token (ici simplifié - en production, utilisez JWT)
    try {
        $user_data = base64_decode($token);
        $user = json_decode($user_data, true);
        return $user;
    } catch (Exception $e) {
        return null;
    }
}

function requireAuth() {
    $user = getAuthenticatedUser();
    if (!$user) {
        jsonResponse(false, 'Authentification requise', null, 401);
    }
    return $user;
}

function requireRole($allowed_roles) {
    $user = requireAuth();
    
    if (!in_array($user['role'], $allowed_roles)) {
        jsonResponse(false, 'Permissions insuffisantes pour le rôle: ' . $user['role'], null, 403);
    }
    
    return $user;
}

function canAccessSite($user, $site_id) {
    // Admin et superviseur peuvent accéder à tous les sites
    if (in_array($user['role'], ['admin', 'superviseur'])) {
        return true;
    }
    
    // Contrôleur et référent : uniquement leur site
    if (in_array($user['role'], ['controleur', 'referent'])) {
        return $user['site_id'] == $site_id;
    }
    
    return false;
}

function canModifyData($user, $data_site_id, $data_user_id = null) {
    switch ($user['role']) {
        case 'admin':
            return true;
            
        case 'superviseur':
            return false; // Superviseur ne peut rien modifier
            
        case 'controleur':
            // Peut valider/supprimer les données de son site
            return $user['site_id'] == $data_site_id;
            
        case 'referent':
            // Peut modifier uniquement ses propres données
            return $user['site_id'] == $data_site_id && $user['id'] == $data_user_id;
            
        default:
            return false;
    }
}

function canValidateData($user, $data_site_id) {
    // Seuls admin et contrôleur peuvent valider
    if ($user['role'] === 'admin') {
        return true;
    }
    
    if ($user['role'] === 'controleur') {
        return $user['site_id'] == $data_site_id;
    }
    
    return false;
}

function getDataFilters($user) {
    $filters = [];
    
    switch ($user['role']) {
        case 'admin':
        case 'superviseur':
            // Aucun filtre - voit tout
            break;
            
        case 'controleur':
            // Filtre par site uniquement
            $filters['site_id'] = $user['site_id'];
            break;
            
        case 'referent':
            // Filtre par site ET par utilisateur
            $filters['site_id'] = $user['site_id'];
            $filters['user_id'] = $user['id'];
            break;
    }
    
    return $filters;
}

function getUsersByRoleAndSite($conn, $role, $site_id) {
    $sql = "SELECT id, nom, prenom FROM utilisateurs 
            WHERE role = ? AND site_id = ? AND actif = 1 
            ORDER BY nom, prenom";
    $stmt = $conn->prepare($sql);
    $stmt->execute([$role, $site_id]);
    return $stmt->fetchAll(PDO::FETCH_ASSOC);
}
?>