<?php
// 📁 Fichier: config/database.php
// 🗄️ Configuration de la base de données pour ONL Dashboard

// Démarrage de la session si pas déjà fait
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

class Database {
    private $host = 'localhost';
    private $db_name = 'softdgid_onl';
    private $username = 'softdgid_pape';
    private $password = 'P@sser0101';
    public $conn;

    public function getConnection() {
        $this->conn = null;
        
        try {
            $dsn = "mysql:host=" . $this->host . ";dbname=" . $this->db_name . ";charset=utf8mb4";
            
            $options = [
                PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
                PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
                PDO::ATTR_EMULATE_PREPARES => false,
                PDO::MYSQL_ATTR_INIT_COMMAND => "SET NAMES utf8mb4"
            ];
            
            $this->conn = new PDO($dsn, $this->username, $this->password, $options);
            $this->conn->query("SELECT 1");
            
        } catch(PDOException $exception) {
            error_log("❌ Erreur DB: " . $exception->getMessage());
        }
        
        return $this->conn;
    }
}

// Configuration des headers CORS
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With');
header('Content-Type: application/json; charset=UTF-8');

// Gestion des requêtes OPTIONS pour CORS
if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
    http_response_code(200);
    exit();
}

// Fonction utilitaire pour les réponses JSON
function jsonResponse($success, $message = '', $data = null, $code = 200) {
    http_response_code($code);
    echo json_encode([
        'success' => $success,
        'message' => $message,
        'data' => $data,
        'timestamp' => date('Y-m-d H:i:s')
    ]);
    exit();
}

// Initialisation de la connexion globale
try {
    $database = new Database();
    $pdo = $database->getConnection();
    
    if (!$pdo) {
        error_log("❌ Échec de connexion à la base de données");
        throw new Exception("Connexion à la base de données impossible");
    }
    
} catch (Exception $e) {
    error_log("❌ Erreur fatale DB: " . $e->getMessage());
    
    // En cas d'erreur, on continue sans DB pour éviter les crashes
    $pdo = null;
}

// Fonctions utilitaires supplémentaires

/**
 * Exécute une requête sécurisée avec gestion d'erreur
 */
function executeQuery($query, $params = [], $fetchMode = PDO::FETCH_ASSOC) {
    global $pdo;
    
    if (!$pdo) {
        return false;
    }
    
    try {
        $stmt = $pdo->prepare($query);
        $stmt->execute($params);
        
        if (stripos($query, 'SELECT') === 0) {
            return $stmt->fetchAll($fetchMode);
        } else {
            return $stmt->rowCount();
        }
        
    } catch (PDOException $e) {
        error_log("❌ Erreur requête: " . $e->getMessage());
        return false;
    }
}

/**
 * Récupère un enregistrement unique
 */
function fetchOne($query, $params = []) {
    global $pdo;
    
    if (!$pdo) {
        return false;
    }
    
    try {
        $stmt = $pdo->prepare($query);
        $stmt->execute($params);
        return $stmt->fetch(PDO::FETCH_ASSOC);
        
    } catch (PDOException $e) {
        error_log("❌ Erreur fetchOne: " . $e->getMessage());
        return false;
    }
}

/**
 * Vérifie si une table existe
 */
function tableExists($tableName) {
    global $pdo;
    
    if (!$pdo) {
        return false;
    }
    
    try {
        $stmt = $pdo->prepare("SHOW TABLES LIKE ?");
        $stmt->execute([$tableName]);
        return $stmt->rowCount() > 0;
        
    } catch (PDOException $e) {
        return false;
    }
}

/**
 * Log des activités utilisateur
 */
function logActivity($userId, $action, $details = '') {
    global $pdo;
    
    if (!$pdo || !tableExists('activity_logs')) {
        return false;
    }
    
    try {
        $stmt = $pdo->prepare("
            INSERT INTO activity_logs (user_id, action, details, ip_address, user_agent, created_at) 
            VALUES (?, ?, ?, ?, ?, NOW())
        ");
        
        return $stmt->execute([
            $userId,
            $action,
            $details,
            $_SERVER['REMOTE_ADDR'] ?? '',
            $_SERVER['HTTP_USER_AGENT'] ?? ''
        ]);
        
    } catch (PDOException $e) {
        error_log("❌ Erreur log activité: " . $e->getMessage());
        return false;
    }
}