<?php
// api/config/direct_test.php - Test direct sans interférence
header('Content-Type: text/html; charset=UTF-8');
echo "<h2>🧪 Test Direct de Connexion</h2><pre>";

// Test 1: Vérification MD5
$password = 'admin123';
$expected_hash = '0192023a7bbd73250516f069df18b500';
$calculated_hash = md5($password);

echo "=== TEST MD5 ===\n";
echo "Mot de passe: '$password'\n";
echo "Hash attendu:  $expected_hash\n";
echo "Hash calculé:  $calculated_hash\n";
echo "Correspond: " . ($expected_hash === $calculated_hash ? "✅ OUI" : "❌ NON") . "\n\n";

// Test 2: Connexion directe à la base
echo "=== TEST CONNEXION BASE ===\n";
try {
    $pdo = new PDO(
        'mysql:host=localhost;dbname=softdgid_toto;charset=utf8mb4',
        'softdgid_pape',
        'P@sser0101',
        [PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION]
    );
    echo "✅ Connexion PDO réussie\n";

    // Test 3: Requête utilisateur
    echo "\n=== TEST REQUÊTE UTILISATEUR ===\n";
    $email = 'admin@onl.sn';
    $stmt = $pdo->prepare("SELECT * FROM utilisateurs WHERE email = ? AND actif = 1");
    $stmt->execute([$email]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($user) {
        echo "✅ Utilisateur trouvé:\n";
        echo "   ID: {$user['id']}\n";
        echo "   Nom: {$user['nom']} {$user['prenom']}\n";
        echo "   Email: {$user['email']}\n";
        echo "   Rôle: {$user['role']}\n";
        echo "   Hash: {$user['mot_de_passe']}\n";
        echo "   Actif: " . ($user['actif'] ? 'OUI' : 'NON') . "\n";
        
        // Test 4: Vérification mot de passe
        echo "\n=== TEST MOT DE PASSE ===\n";
        $db_hash = $user['mot_de_passe'];
        $input_hash = md5($password);
        
        echo "Hash DB:    '$db_hash'\n";
        echo "Hash Input: '$input_hash'\n";
        echo "Longueur DB: " . strlen($db_hash) . "\n";
        echo "Longueur Input: " . strlen($input_hash) . "\n";
        echo "Égaux: " . ($db_hash === $input_hash ? "✅ OUI" : "❌ NON") . "\n";
        
        if ($db_hash === $input_hash) {
            echo "\n🎉 AUTHENTIFICATION RÉUSSIE !\n";
            
            // Test 5: Simulation complète du login
            echo "\n=== SIMULATION LOGIN COMPLET ===\n";
            
            $user_response = [
                'id' => (int)$user['id'],
                'nom' => $user['nom'],
                'prenom' => $user['prenom'],
                'email' => $user['email'],
                'role' => $user['role'],
                'site_id' => $user['site_id'],
                'actif' => (bool)$user['actif']
            ];
            
            $token_data = [
                'user_id' => $user['id'],
                'email' => $user['email'],
                'role' => $user['role'],
                'exp' => time() + (24 * 60 * 60)
            ];
            
            $token = base64_encode(json_encode($token_data));
            
            echo "👤 Données utilisateur: " . json_encode($user_response, JSON_PRETTY_PRINT) . "\n";
            echo "🔑 Token généré: " . substr($token, 0, 50) . "...\n";
            
            echo "\n✅ TOUT FONCTIONNE PARFAITEMENT !\n";
            echo "Le problème n'est PAS dans la base de données.\n";
            
        } else {
            echo "\n❌ ÉCHEC AUTHENTIFICATION\n";
        }
        
    } else {
        echo "❌ Utilisateur non trouvé\n";
    }
    
} catch (Exception $e) {
    echo "❌ Erreur: " . $e->getMessage() . "\n";
}

echo "\n=== TEST DIRECT API ===\n";
echo "Maintenant testons l'API directement...\n";

// Test 6: Appel direct à l'API (simulation)
$_SERVER['REQUEST_METHOD'] = 'POST';
$_POST = [];
$test_data = json_encode(['email' => 'admin@onl.sn', 'password' => 'admin123']);

// Simuler file_get_contents("php://input")
echo "Données à envoyer: $test_data\n";

ob_start();
try {
    // Inclusion directe du login.php
    $GLOBALS['test_input'] = $test_data;
    
    // Mock file_get_contents
    function mock_file_get_contents($filename) {
        if ($filename === "php://input") {
            return $GLOBALS['test_input'];
        }
        return file_get_contents($filename);
    }
    
    echo "\n🔄 Test de l'API login.php...\n";
    
} catch (Exception $e) {
    echo "Erreur test API: " . $e->getMessage() . "\n";
}
$api_output = ob_get_clean();
echo $api_output;

echo "</pre>";

// Afficher un formulaire de test simple
echo "<hr><h3>🧪 Test Manuel Rapide</h3>";
echo "<form method='post'>";
echo "<input type='email' name='test_email' placeholder='Email' value='admin@onl.sn'><br><br>";
echo "<input type='password' name='test_password' placeholder='Mot de passe' value='admin123'><br><br>";
echo "<button type='submit'>Tester Login Direct</button>";
echo "</form>";

if ($_POST) {
    echo "<h4>📋 Résultat du Test:</h4><pre>";
    
    $test_email = $_POST['test_email'] ?? '';
    $test_password = $_POST['test_password'] ?? '';
    
    if ($test_email && $test_password) {
        try {
            $pdo = new PDO('mysql:host=localhost;dbname=softdgid_toto;charset=utf8mb4', 'softdgid_pape', 'P@sser0101');
            $stmt = $pdo->prepare("SELECT * FROM utilisateurs WHERE email = ? AND actif = 1");
            $stmt->execute([$test_email]);
            $user = $stmt->fetch(PDO::FETCH_ASSOC);
            
            if ($user && md5($test_password) === $user['mot_de_passe']) {
                echo "✅ LOGIN RÉUSSI !\n";
                echo "Utilisateur: {$user['nom']} {$user['prenom']}\n";
                echo "Rôle: {$user['role']}\n";
            } else {
                echo "❌ LOGIN ÉCHOUÉ\n";
                if (!$user) {
                    echo "Utilisateur non trouvé avec email: $test_email\n";
                } else {
                    echo "Mot de passe incorrect\n";
                    echo "Hash attendu: {$user['mot_de_passe']}\n";
                    echo "Hash fourni: " . md5($test_password) . "\n";
                }
            }
        } catch (Exception $e) {
            echo "❌ Erreur: " . $e->getMessage() . "\n";
        }
    }
    echo "</pre>";
}

echo "<hr>";
echo "<p><strong>🎯 Si ce test fonctionne, le problème est dans le fichier login.php</strong></p>";
echo "<p><a href='../auth/login.php' target='_blank'>🔗 Tester l'API login.php directement</a></p>";
echo "<p><a href='../../test_login.html' target='_blank'>🔗 Retour au test complet</a></p>";
?>
