<?php
// api/config/test_db.php
include_once 'database.php';

echo "=== Test Connexion Base de Données ===\n";

try {
    $database = new Database();
    $db = $database->getConnection();
    
    if ($db) {
        echo "✅ Connexion réussie !\n";
        
        // Test des tables
        $tables = ['sites', 'utilisateurs', 'profils_topographiques', 'releves_dechets'];
        
        foreach ($tables as $table) {
            $query = "SELECT COUNT(*) as count FROM $table";
            $stmt = $db->prepare($query);
            $stmt->execute();
            $count = $stmt->fetch(PDO::FETCH_ASSOC)['count'];
            echo "📊 Table '$table': $count enregistrements\n";
        }
        
    } else {
        echo "❌ Échec de connexion\n";
    }
    
} catch (Exception $e) {
    echo "❌ Erreur: " . $e->getMessage() . "\n";
}
?>