<?php
// ===== SYSTÈME DE LOGGING SQL POUR DÉBOGAGE =====

// Fonction pour logger les requêtes SQL
function logSQLQuery($query, $params = [], $error = null) {
    $logFile = __DIR__ . '/sql_debug_log.txt';
    $timestamp = date('Y-m-d H:i:s');
    
    $logEntry = "\n" . str_repeat("=", 80) . "\n";
    $logEntry .= "TIMESTAMP: $timestamp\n";
    $logEntry .= str_repeat("-", 40) . "\n";
    
    // Remplacer les placeholders par les vraies valeurs
    $finalQuery = $query;
    if (!empty($params)) {
        $logEntry .= "PARAMÈTRES ORIGINAUX:\n";
        foreach ($params as $key => $value) {
            $logEntry .= "  $key => " . (is_null($value) ? 'NULL' : "'$value'") . "\n";
            
            // Remplacer le placeholder dans la requête
            if (is_string($value)) {
                $finalQuery = str_replace($key, "'$value'", $finalQuery);
            } elseif (is_null($value)) {
                $finalQuery = str_replace($key, 'NULL', $finalQuery);
            } else {
                $finalQuery = str_replace($key, $value, $finalQuery);
            }
        }
        $logEntry .= "\n";
    }
    
    $logEntry .= "REQUÊTE SQL FINALE (PRÊTE POUR PHPMYADMIN):\n";
    $logEntry .= str_repeat("-", 50) . "\n";
    $logEntry .= $finalQuery . ";\n";
    $logEntry .= str_repeat("-", 50) . "\n";
    
    if ($error) {
        $logEntry .= "ERREUR:\n";
        $logEntry .= "$error\n";
        $logEntry .= str_repeat("-", 30) . "\n";
    }
    
    $logEntry .= str_repeat("=", 80) . "\n";
    
    // Écrire dans le fichier
    file_put_contents($logFile, $logEntry, FILE_APPEND | LOCK_EX);
}

// Fonction pour nettoyer le log (optionnelle)
function clearSQLLog() {
    $logFile = __DIR__ . '/sql_debug_log.txt';
    $header = "=== LOG DEBUG SQL - DÉCHETS ===\n";
    $header .= "Généré le: " . date('Y-m-d H:i:s') . "\n";
    $header .= "Toutes les requêtes sont prêtes à copier/coller dans phpMyAdmin\n\n";
    file_put_contents($logFile, $header);
}


// ===== LOGGER AUSSI LES DONNÉES REÇUES =====
function logReceivedData($data) {
    $logFile = __DIR__ . '/sql_debug_log.txt';
    $timestamp = date('Y-m-d H:i:s');
    
    $logEntry = "\n" . str_repeat("*", 60) . "\n";
    $logEntry .= "DONNÉES REÇUES - $timestamp\n";
    $logEntry .= str_repeat("*", 60) . "\n";
    $logEntry .= "JSON BRUT:\n";
    $logEntry .= json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE) . "\n";
    $logEntry .= str_repeat("*", 60) . "\n";
    
    file_put_contents($logFile, $logEntry, FILE_APPEND | LOCK_EX);
}

// ===== TEMPLATE COMPLET POUR CREATE.PHP =====
?>

