<?php
/**
 * Test simple de get.php
 * Emplacement : /public_html/onl/api/profils/test_simple.php
 */

echo "<h2>Test simple de get.php</h2>";

// Test direct de l'URL
$url = "https://dgidbail.sn/onl/api/profils/get.php?id=12";

echo "<h3>Test de l'URL : $url</h3>";

$context = stream_context_create([
    'http' => [
        'timeout' => 10,
        'ignore_errors' => true
    ]
]);

$response = file_get_contents($url, false, $context);

if ($response === false) {
    echo "❌ Erreur : Impossible de récupérer la réponse<br>";
} else {
    echo "<h4>✅ Réponse reçue :</h4>";
    echo "<pre style='background: #f5f5f5; padding: 10px; border-radius: 5px; max-height: 400px; overflow: auto;'>";
    echo htmlspecialchars($response);
    echo "</pre>";
    
    // Test JSON
    $json = json_decode($response, true);
    if (json_last_error() === JSON_ERROR_NONE) {
        echo "<h4>✅ JSON valide</h4>";
        if (isset($json['success']) && $json['success']) {
            echo "<p style='color: green;'>✅ Succès : " . $json['message'] . "</p>";
            if (isset($json['data']['identification'])) {
                echo "<p><strong>Profil ID :</strong> " . $json['data']['identification']['id'] . "</p>";
                echo "<p><strong>Numéro profil :</strong> " . $json['data']['identification']['numero_profil_borne'] . "</p>";
            }
        } else {
            echo "<p style='color: red;'>❌ Erreur : " . ($json['message'] ?? 'Erreur inconnue') . "</p>";
        }
    } else {
        echo "<h4>❌ JSON invalide : " . json_last_error_msg() . "</h4>";
    }
}
?>