<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

require_once '../config/database.php';

try {
    $database = new Database();
    $pdo = $database->getConnection();
    
    if (!$pdo) {
        throw new Exception('Impossible de se connecter à la base de données');
    }
    
    $sql = "SELECT 
                s.id, 
                s.nom_site, 
                s.region, 
                s.latitude, 
                s.longitude,
                s.courant_vent,
                s.created_at,
                COUNT(DISTINCT u.id) as nb_utilisateurs,
                COUNT(DISTINCT pt.id) as nb_profils_topo,
                COUNT(DISTINCT rd.id) as nb_releves_dechets
            FROM sites s 
            LEFT JOIN utilisateurs u ON s.id = u.site_id AND u.actif = 1
            LEFT JOIN profils_topographiques pt ON s.id = pt.site_id
            LEFT JOIN releves_dechets rd ON s.id = rd.site_id
            GROUP BY s.id, s.nom_site, s.region, s.latitude, s.longitude, s.created_at
            ORDER BY s.nom_site ASC";
    
    $stmt = $pdo->prepare($sql);
    $stmt->execute();
    $sites = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    foreach ($sites as &$site) {
        $site['latitude'] = (float) $site['latitude'];
        $site['longitude'] = (float) $site['longitude'];
        
        if ($site['created_at']) {
            $site['created_at'] = date('Y-m-d H:i:s', strtotime($site['created_at']));
        }
        
        $site['stats'] = [
            'utilisateurs' => (int) $site['nb_utilisateurs'],
            'profils_topographiques' => (int) $site['nb_profils_topo'],
            'releves_dechets' => (int) $site['nb_releves_dechets'],
            'total_activites' => (int) $site['nb_profils_topo'] + (int) $site['nb_releves_dechets']
        ];
        
        $site['coordonnees_display'] = number_format($site['latitude'], 6) . ', ' . number_format($site['longitude'], 6);
        
        $site['permissions'] = [
            'can_view' => true,
            'can_edit' => false,
            'can_delete' => false
        ];
        
        unset($site['nb_utilisateurs'], $site['nb_profils_topo'], $site['nb_releves_dechets']);
    }
    
    echo json_encode([
        'success' => true,
        'message' => 'Sites récupérés avec succès',
        'data' => $sites,
        'count' => count($sites),
        'timestamp' => date('Y-m-d H:i:s')
    ]);
    
} catch (Exception $e) {
    error_log("Erreur sites/list: " . $e->getMessage());
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage(),
        'data' => [],
        'timestamp' => date('Y-m-d H:i:s')
    ]);
}
?>