<?php
// stats/dashboard.php
require_once '../config/database.php';

try {
    // Initialiser la connexion DB
    $database = new Database();
    $conn = $database->getConnection();
    
    if (!$conn) {
        jsonResponse(false, 'Erreur de connexion à la base de données', null, 500);
    }
    
    // Statistiques générales
    $stats = [];
    
    // Compter les profils topographiques
    $stmt = $conn->query("SELECT COUNT(*) as total FROM profils_topographiques");
    $stats['total_profils'] = $stmt->fetch()['total'];
    
    // Compter les relevés de déchets
    $stmt = $conn->query("SELECT COUNT(*) as total FROM releves_dechets");
    $stats['total_dechets'] = $stmt->fetch()['total'];
    
    // Compter les utilisateurs actifs
    $stmt = $conn->query("SELECT COUNT(*) as total FROM utilisateurs WHERE actif = 1");
    $stats['total_users'] = $stmt->fetch()['total'];
    
    // Compter les référents actifs
    $stmt = $conn->query("SELECT COUNT(*) as total FROM utilisateurs WHERE role = 'referent' AND actif = 1");
    $stats['total_referents'] = $stmt->fetch()['total'];
    
    // Compter les sites
    $stmt = $conn->query("SELECT COUNT(*) as total FROM sites");
    $stats['total_sites'] = $stmt->fetch()['total'];
    
    // Statistiques par statut pour les profils
    $stmt = $conn->query("
        SELECT statut, COUNT(*) as count 
        FROM profils_topographiques 
        GROUP BY statut
    ");
    $profils_par_statut = [];
    while ($row = $stmt->fetch()) {
        $profils_par_statut[$row['statut']] = intval($row['count']);
    }
    $stats['profils_par_statut'] = $profils_par_statut;
    
    // Statistiques par statut pour les déchets
    $stmt = $conn->query("
        SELECT statut, COUNT(*) as count 
        FROM releves_dechets 
        GROUP BY statut
    ");
    $dechets_par_statut = [];
    while ($row = $stmt->fetch()) {
        $dechets_par_statut[$row['statut']] = intval($row['count']);
    }
    $stats['dechets_par_statut'] = $dechets_par_statut;
    
    // Activité récente (derniers 7 jours)
    $stmt = $conn->query("
        SELECT 
            COUNT(CASE WHEN created_at >= DATE_SUB(NOW(), INTERVAL 7 DAY) THEN 1 END) as profils_recent,
            COUNT(*) as profils_total
        FROM profils_topographiques
    ");
    $activite_profils = $stmt->fetch();
    
    $stmt = $conn->query("
        SELECT 
            COUNT(CASE WHEN created_at >= DATE_SUB(NOW(), INTERVAL 7 DAY) THEN 1 END) as dechets_recent,
            COUNT(*) as dechets_total
        FROM releves_dechets
    ");
    $activite_dechets = $stmt->fetch();
    
    $stats['activite_recente'] = [
        'profils_7j' => intval($activite_profils['profils_recent']),
        'dechets_7j' => intval($activite_dechets['dechets_recent'])
    ];
    
    // Top 5 des sites les plus actifs
    $stmt = $conn->query("
        SELECT 
            s.nom_site,
            s.region,
            COALESCE(p.nb_profils, 0) as nb_profils,
            COALESCE(d.nb_dechets, 0) as nb_dechets,
            (COALESCE(p.nb_profils, 0) + COALESCE(d.nb_dechets, 0)) as total_activite
        FROM sites s
        LEFT JOIN (
            SELECT site_id, COUNT(*) as nb_profils 
            FROM profils_topographiques 
            GROUP BY site_id
        ) p ON s.id = p.site_id
        LEFT JOIN (
            SELECT site_id, COUNT(*) as nb_dechets 
            FROM releves_dechets 
            GROUP BY site_id
        ) d ON s.id = d.site_id
        ORDER BY total_activite DESC
        LIMIT 5
    ");
    $top_sites = [];
    while ($row = $stmt->fetch()) {
        $top_sites[] = [
            'nom_site' => $row['nom_site'],
            'region' => $row['region'],
            'nb_profils' => intval($row['nb_profils']),
            'nb_dechets' => intval($row['nb_dechets']),
            'total_activite' => intval($row['total_activite'])
        ];
    }
    $stats['top_sites'] = $top_sites;
    
    jsonResponse(true, 'Statistiques récupérées avec succès', $stats);
    
} catch (Exception $e) {
    error_log("Erreur stats/dashboard.php: " . $e->getMessage());
    jsonResponse(false, 'Erreur lors de la récupération des statistiques: ' . $e->getMessage(), null, 500);
}
?>