<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST');
header('Access-Control-Allow-Headers: Content-Type, Authorization');

require_once '../config/database.php';
require_once '../config/auth_middleware.php';

// Vérifier l'authentification
$auth = checkAuth();
if (!$auth['success']) {
    http_response_code(401);
    echo json_encode($auth);
    exit;
}

try {
    // Vérifier si c'est une requête POST
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        throw new Exception('Méthode non autorisée');
    }
    
    // Vérifier si un fichier a été uploadé
    if (!isset($_FILES['photo']) || $_FILES['photo']['error'] !== UPLOAD_ERR_OK) {
        throw new Exception('Aucun fichier uploadé ou erreur d\'upload');
    }
    
    // Récupérer l'ID utilisateur
    $user_id = $_POST['user_id'] ?? null;
    if (!$user_id) {
        throw new Exception('ID utilisateur requis');
    }
    
    $file = $_FILES['photo'];
    
    // Vérifications du fichier
    $allowed_types = ['image/jpeg', 'image/png', 'image/gif'];
    if (!in_array($file['type'], $allowed_types)) {
        throw new Exception('Type de fichier non autorisé. Seuls JPG, PNG et GIF sont acceptés.');
    }
    
    // Vérifier la taille (max 5MB)
    $max_size = 5 * 1024 * 1024; // 5MB
    if ($file['size'] > $max_size) {
        throw new Exception('Fichier trop volumineux. Taille maximum: 5MB');
    }
    
    // Lire le contenu du fichier
    $photo_data = file_get_contents($file['tmp_name']);
    if ($photo_data === false) {
        throw new Exception('Erreur lors de la lecture du fichier');
    }
    
    // Connexion à la base de données
    $database = new Database();
    $pdo = $database->getConnection();
    
    if (!$pdo) {
        throw new Exception('Impossible de se connecter à la base de données');
    }
    
    // Vérifier que l'utilisateur existe
    $check_sql = "SELECT id FROM utilisateurs WHERE id = ?";
    $check_stmt = $pdo->prepare($check_sql);
    $check_stmt->execute([$user_id]);
    
    if (!$check_stmt->fetch()) {
        throw new Exception('Utilisateur non trouvé');
    }
    
    // Mettre à jour la photo
    $sql = "UPDATE utilisateurs SET photo = ? WHERE id = ?";
    $stmt = $pdo->prepare($sql);
    $result = $stmt->execute([$photo_data, $user_id]);
    
    if (!$result) {
        throw new Exception('Erreur lors de la sauvegarde de la photo');
    }
    
    echo json_encode([
        'success' => true,
        'message' => 'Photo uploadée avec succès',
        'data' => [
            'user_id' => $user_id,
            'file_size' => $file['size'],
            'file_type' => $file['type']
        ],
        'timestamp' => date('Y-m-d H:i:s')
    ]);
    
} catch (Exception $e) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage(),
        'timestamp' => date('Y-m-d H:i:s')
    ]);
}
?>