<?php
// api/auth/login.php - Version finale corrigée
error_reporting(0); // Désactiver les erreurs en production
ini_set('display_errors', 0);

// Headers obligatoires
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With');
header('Content-Type: application/json; charset=UTF-8');

// Gérer les requêtes OPTIONS (preflight CORS)
if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
    http_response_code(200);
    exit();
}

// Vérifier la méthode
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode([
        'success' => false,
        'message' => 'Méthode non autorisée. Utilisez POST.',
        'timestamp' => date('Y-m-d H:i:s')
    ]);
    exit();
}

try {
    // Connexion à la base de données
    $pdo = new PDO(
        'mysql:host=localhost;dbname=softdgid_onl;charset=utf8mb4',
        'softdgid_pape',
        'P@sser0101',
        [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC
        ]
    );
    
    // Lire les données JSON
    $json_input = file_get_contents("php://input");
    
    if (empty($json_input)) {
        throw new Exception('Aucune donnée reçue');
    }
    
    $data = json_decode($json_input, true);
    
    if (json_last_error() !== JSON_ERROR_NONE) {
        throw new Exception('Format JSON invalide');
    }
    
    if (empty($data['email']) || empty($data['password'])) {
        throw new Exception('Email et mot de passe requis');
    }
    
    $email = trim($data['email']);
    $password = $data['password'];
    
    // Validation email
    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        throw new Exception('Format email invalide');
    }
    
    // Requête utilisateur avec jointure sites
    $query = "SELECT 
                u.id,
                u.nom,
                u.prenom,
                u.telephone,
                u.email,
                u.mot_de_passe,
                u.role,
                u.site_id,
                u.actif,
                s.nom_site,
                s.region
              FROM utilisateurs u 
              LEFT JOIN sites s ON u.site_id = s.id 
              WHERE u.email = ? AND u.actif = 1 
              LIMIT 1";
    
    $stmt = $pdo->prepare($query);
    $stmt->execute([$email]);
    
    if ($stmt->rowCount() === 0) {
        // Utilisateur non trouvé
        http_response_code(401);
        echo json_encode([
            'success' => false,
            'message' => 'Identifiants incorrects',
            'timestamp' => date('Y-m-d H:i:s')
        ]);
        exit();
    }
    
    $user = $stmt->fetch();
    
    // Vérification du mot de passe
    $password_hash = md5($password);
    
    if ($password_hash !== $user['mot_de_passe']) {
        // Mot de passe incorrect
        http_response_code(401);
        echo json_encode([
            'success' => false,
            'message' => 'Identifiants incorrects',
            'timestamp' => date('Y-m-d H:i:s')
        ]);
        exit();
    }
    
    // Authentification réussie - Préparer la réponse
    $user_data = [
        'id' => (int)$user['id'],
        'nom' => $user['nom'],
        'prenom' => $user['prenom'],
        'email' => $user['email'],
        'telephone' => $user['telephone'],
        'role' => $user['role'],
        'site_id' => $user['site_id'] ? (int)$user['site_id'] : null,
        'nom_site' => $user['nom_site'],
        'region' => $user['region'],
        'actif' => true
    ];
    
    // Générer le token
    $token_payload = [
        'user_id' => $user['id'],
        'email' => $user['email'],
        'role' => $user['role'],
        'site_id' => $user['site_id'],
        'iat' => time(),
        'exp' => time() + (24 * 60 * 60) // 24 heures
    ];
    
    $token = base64_encode(json_encode($token_payload));
    
    // Définir les permissions selon le rôle
    $permissions = [
        'admin' => [
            'view_all_sites' => true,
            'manage_users' => true,
            'validate_data' => true,
            'export_data' => true,
            'system_settings' => true
        ],
        'superviseur' => [
            'view_all_sites' => true,
            'manage_users' => false,
            'validate_data' => true,
            'export_data' => true,
            'system_settings' => false
        ],
        'controleur' => [
            'view_all_sites' => false,
            'manage_users' => false,
            'validate_data' => true,
            'export_data' => true,
            'system_settings' => false
        ],
        'referent' => [
            'view_all_sites' => false,
            'manage_users' => false,
            'validate_data' => false,
            'export_data' => false,
            'system_settings' => false
        ]
    ];
    
    $user_permissions = $permissions[$user['role']] ?? $permissions['referent'];
    
    // Mettre à jour la dernière connexion (optionnel)
    try {
        $update_stmt = $pdo->prepare("UPDATE utilisateurs SET last_sync = NOW() WHERE id = ?");
        $update_stmt->execute([$user['id']]);
    } catch (Exception $e) {
        // Ignorer l'erreur de mise à jour si la colonne n'existe pas
    }
    
    // Réponse de succès
    http_response_code(200);
    echo json_encode([
        'success' => true,
        'message' => 'Connexion réussie',
        'token' => $token,
        'user' => $user_data,
        'permissions' => $user_permissions,
        'timestamp' => date('Y-m-d H:i:s')
    ]);
    
} catch (PDOException $e) {
    // Erreur de base de données
    error_log("LOGIN PDO Error: " . $e->getMessage());
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Erreur de base de données',
        'timestamp' => date('Y-m-d H:i:s')
    ]);
    
} catch (Exception $e) {
    // Autres erreurs
    error_log("LOGIN Error: " . $e->getMessage());
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage(),
        'timestamp' => date('Y-m-d H:i:s')
    ]);
}
?>