<?php
// api/auth/login_debug.php - Version debug complète du login
error_reporting(E_ALL);
ini_set('display_errors', 1);

include_once '../config/database.php';

// Fonction de debug
function debug_log($message) {
    echo "DEBUG: " . $message . "\n";
    error_log("LOGIN_DEBUG: " . $message);
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header('Content-Type: application/json');
    echo json_encode([
        'success' => false,
        'message' => 'Méthode non autorisée. Utilisez POST.',
        'debug' => 'REQUEST_METHOD = ' . $_SERVER['REQUEST_METHOD']
    ]);
    exit();
}

debug_log("=== DÉBUT LOGIN DEBUG ===");

try {
    // Lire les données JSON
    $json_input = file_get_contents("php://input");
    debug_log("Input reçu: " . $json_input);
    
    $data = json_decode($json_input, true);
    debug_log("JSON décodé: " . print_r($data, true));
    
    if (json_last_error() !== JSON_ERROR_NONE) {
        throw new Exception('Erreur JSON: ' . json_last_error_msg());
    }
    
    if (empty($data['email']) || empty($data['password'])) {
        throw new Exception('Email ou mot de passe manquant');
    }
    
    $email = trim($data['email']);
    $password = $data['password'];
    
    debug_log("Email: $email");
    debug_log("Password: [MASQUÉ]");
    debug_log("Password hash: " . md5($password));
    
    // Connexion base
    debug_log("Tentative connexion base...");
    $database = new Database();
    $db = $database->getConnection();
    
    if (!$db) {
        throw new Exception('Connexion base échouée');
    }
    debug_log("Connexion base réussie");
    
    // Requête utilisateur
    debug_log("Requête utilisateur...");
    $query = "SELECT u.*, s.nom_site, s.region FROM utilisateurs u LEFT JOIN sites s ON u.site_id = s.id WHERE u.email = ? AND u.actif = 1";
    $stmt = $db->prepare($query);
    $stmt->execute([$email]);
    
    debug_log("Requête exécutée, rowCount: " . $stmt->rowCount());
    
    if ($stmt->rowCount() === 0) {
        throw new Exception('Utilisateur non trouvé');
    }
    
    $user = $stmt->fetch(PDO::FETCH_ASSOC);
    debug_log("Utilisateur trouvé: " . $user['nom'] . " " . $user['prenom']);
    debug_log("Hash en base: " . $user['mot_de_passe']);
    
    // Vérification mot de passe
    $password_hash = md5($password);
    debug_log("Hash calculé: " . $password_hash);
    debug_log("Hashes égaux: " . ($password_hash === $user['mot_de_passe'] ? 'OUI' : 'NON'));
    
    if ($password_hash !== $user['mot_de_passe']) {
        throw new Exception('Mot de passe incorrect');
    }
    
    debug_log("Authentification réussie");
    
    // Préparer la réponse
    unset($user['mot_de_passe']);
    
    $token_data = [
        'user_id' => $user['id'],
        'email' => $user['email'],
        'role' => $user['role'],
        'exp' => time() + (24 * 60 * 60)
    ];
    
    $token = base64_encode(json_encode($token_data));
    debug_log("Token généré: " . substr($token, 0, 50) . "...");
    
    $response = [
        'success' => true,
        'message' => 'Connexion réussie',
        'token' => $token,
        'user' => [
            'id' => (int)$user['id'],
            'nom' => $user['nom'],
            'prenom' => $user['prenom'],
            'email' => $user['email'],
            'role' => $user['role'],
            'site_id' => $user['site_id'] ? (int)$user['site_id'] : null,
            'nom_site' => $user['nom_site'],
            'region' => $user['region']
        ],
        'timestamp' => date('Y-m-d H:i:s')
    ];
    
    debug_log("Réponse préparée");
    
    header('Content-Type: application/json');
    echo json_encode($response);
    
    debug_log("=== FIN LOGIN DEBUG - SUCCÈS ===");
    
} catch (Exception $e) {
    debug_log("ERREUR: " . $e->getMessage());
    debug_log("=== FIN LOGIN DEBUG - ÉCHEC ===");
    
    header('Content-Type: application/json');
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage(),
        'debug' => [
            'file' => $e->getFile(),
            'line' => $e->getLine(),
            'trace' => $e->getTraceAsString()
        ],
        'timestamp' => date('Y-m-d H:i:s')
    ]);
}
?>