<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization, Accept');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

require_once '../config/database.php';

try {
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        throw new Exception('Méthode non autorisée');
    }
    
    $input = json_decode(file_get_contents('php://input'), true);
    
    if (!$input || empty($input['email']) || empty($input['password'])) {
        throw new Exception('Email et mot de passe requis');
    }
    
    $database = new Database();
    $pdo = $database->getConnection();
    
    if (!$pdo) {
        throw new Exception('Erreur de connexion à la base de données');
    }
    
    $sql = "SELECT u.*, s.nom_site, s.region, s.latitude, s.longitude
            FROM utilisateurs u
            LEFT JOIN sites s ON u.site_id = s.id
            WHERE u.email = ? AND u.actif = 1";
    
    $stmt = $pdo->prepare($sql);
    $stmt->execute([strtolower(trim($input['email']))]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$user || md5($input['password']) !== $user['mot_de_passe']) {
        throw new Exception('Identifiants incorrects');
    }
    
    $token = bin2hex(random_bytes(32));
    
    $userData = [
        'id' => $user['id'],
        'nom' => $user['nom'],
        'prenom' => $user['prenom'],
        'email' => $user['email'],
        'telephone' => $user['telephone'],
        'role' => $user['role'],
        'site_id' => $user['site_id'],
        'site_info' => null
    ];
    
    if ($user['nom_site']) {
        $userData['site_info'] = [
            'id' => $user['site_id'],
            'nom' => $user['nom_site'],
            'region' => $user['region'],
            'latitude' => (float) $user['latitude'],
            'longitude' => (float) $user['longitude']
        ];
    }
    
    $sitesStmt = $pdo->query("SELECT id, nom_site, region, latitude, longitude FROM sites ORDER BY nom_site");
    $sites = $sitesStmt->fetchAll(PDO::FETCH_ASSOC);
    
    foreach ($sites as &$site) {
        $site['latitude'] = (float) $site['latitude'];
        $site['longitude'] = (float) $site['longitude'];
    }
    
    echo json_encode([
        'success' => true,
        'message' => 'Connexion réussie',
        'data' => [
            'user' => $userData,
            'token' => $token,
            'sites' => $sites,
            'server_time' => date('Y-m-d H:i:s'),
            'permissions' => [
                'can_create_profils' => in_array($user['role'], ['referent', 'superviseur', 'admin']),
                'can_create_dechets' => in_array($user['role'], ['referent', 'superviseur', 'admin']),
                'can_validate' => in_array($user['role'], ['superviseur', 'admin'])
            ]
        ]
    ]);
    
} catch (Exception $e) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage(),
        'timestamp' => date('Y-m-d H:i:s')
    ]);
}
?>