<?php


// api/auth/validate.php - Validation des tokens
include_once '../config/database.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $headers = getallheaders();
    $auth_header = $headers['Authorization'] ?? '';
    
    if (strpos($auth_header, 'Bearer ') !== 0) {
        http_response_code(401);
        echo json_encode(['success' => false, 'message' => 'Token manquant']);
        exit();
    }
    
    $token = substr($auth_header, 7);
    $decoded = validateToken($token);
    
    if (!$decoded) {
        http_response_code(401);
        echo json_encode(['success' => false, 'message' => 'Token invalide']);
        exit();
    }
    
    // Vérifier que l'utilisateur existe toujours
    $database = new Database();
    $db = $database->getConnection();
    
    $query = "SELECT id, nom, email, role, actif FROM utilisateurs WHERE id = ? AND actif = 1";
    $stmt = $db->prepare($query);
    $stmt->bindParam(1, $decoded['user_id']);
    $stmt->execute();
    
    if ($stmt->rowCount() === 0) {
        http_response_code(401);
        echo json_encode(['success' => false, 'message' => 'Utilisateur introuvable']);
        exit();
    }
    
    $user = $stmt->fetch(PDO::FETCH_ASSOC);
    
    echo json_encode([
        'success' => true,
        'user' => $user,
        'token_data' => $decoded
    ]);
}
?>