<?php
// api/config/test_connection.php - Test de diagnostic
include_once 'database.php';

echo "<h2>🔍 Diagnostic Connexion Base de Données</h2>";
echo "<pre>";

// Test 1: Informations du serveur
echo "=== INFORMATIONS SERVEUR ===\n";
echo "PHP Version: " . phpversion() . "\n";
echo "Server: " . ($_SERVER['HTTP_HOST'] ?? 'Non défini') . "\n";
echo "Script: " . __FILE__ . "\n";
echo "Date: " . date('Y-m-d H:i:s') . "\n\n";

// Test 2: Extensions PHP
echo "=== EXTENSIONS PHP ===\n";
echo "PDO disponible: " . (extension_loaded('pdo') ? '✅ Oui' : '❌ Non') . "\n";
echo "PDO MySQL disponible: " . (extension_loaded('pdo_mysql') ? '✅ Oui' : '❌ Non') . "\n";
echo "MySQL client version: " . (function_exists('mysql_get_client_info') ? mysql_get_client_info() : 'N/A') . "\n\n";

// Test 3: Paramètres de connexion
echo "=== PARAMÈTRES DE CONNEXION ===\n";
$database = new Database();
echo "Host: localhost\n";
echo "Database: softdgid_toto\n";
echo "Username: softdgid_pape\n";
echo "Password: " . str_repeat('*', strlen('P@sser0101')) . "\n\n";

// Test 4: Tentative de connexion
echo "=== TEST DE CONNEXION ===\n";
try {
    $db = $database->getConnection();
    
    if ($db) {
        echo "✅ Connexion réussie !\n";
        
        $info = $database->testConnection();
        if ($info) {
            echo "MySQL Version: " . $info['version'] . "\n";
            echo "Base active: " . $info['database'] . "\n";
            echo "Utilisateur: " . $info['user'] . "\n";
        }
        
        // Test des tables
        echo "\n=== TABLES DISPONIBLES ===\n";
        $stmt = $db->query("SHOW TABLES");
        $tables = $stmt->fetchAll(PDO::FETCH_COLUMN);
        
        if (empty($tables)) {
            echo "❌ Aucune table trouvée\n";
        } else {
            foreach ($tables as $table) {
                echo "📋 $table\n";
            }
        }
        
        // Test utilisateurs
        if (in_array('utilisateurs', $tables)) {
            echo "\n=== TEST TABLE UTILISATEURS ===\n";
            $stmt = $db->query("SELECT COUNT(*) as count FROM utilisateurs");
            $count = $stmt->fetch()['count'];
            echo "Nombre d'utilisateurs: $count\n";
            
            if ($count > 0) {
                $stmt = $db->query("SELECT id, nom, email, role FROM utilisateurs LIMIT 3");
                $users = $stmt->fetchAll();
                foreach ($users as $user) {
                    echo "👤 {$user['id']}: {$user['nom']} ({$user['email']}) - {$user['role']}\n";
                }
            }
        }
        
    } else {
        echo "❌ Connexion échouée\n";
    }
    
} catch (Exception $e) {
    echo "❌ ERREUR: " . $e->getMessage() . "\n";
    echo "Code: " . $e->getCode() . "\n";
    echo "Fichier: " . $e->getFile() . ":" . $e->getLine() . "\n";
}

echo "\n=== FIN DU DIAGNOSTIC ===\n";
echo "</pre>";

echo "<hr>";
echo "<h3>🔧 Actions Recommandées</h3>";
echo "<ul>";
echo "<li><strong>Si connexion échouée:</strong> Vérifiez les identifiants MySQL</li>";
echo "<li><strong>Si tables manquantes:</strong> Importez le fichier structure.sql</li>";
echo "<li><strong>Si utilisateurs manquants:</strong> Exécutez les INSERT du fichier SQL</li>";
echo "</ul>";

echo "<p><a href='../auth/login.php' class='btn btn-primary'>🔄 Retester le Login</a></p>";
?>

