<?php
// api/export/dechets.php - VERSION SANS VÉRIFICATION TOKEN + CONNEXION DIRECTE
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit(0);
}

// CONNEXION DIRECTE SANS INCLUDES
$user = [
    'nom' => 'Système',
    'prenom' => 'Export',
    'role' => 'admin',
    'site_id' => null
];

try {
    // CONNEXION DIRECTE À LA BASE DE DONNÉES
    $pdo = new PDO(
        "mysql:host=localhost;dbname=softdgid_onl;charset=utf8mb4",
        "softdgid_pape",
        "P@sser0101",
        [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
            PDO::ATTR_EMULATE_PREPARES => false
        ]
    );
    
    // GESTION DU PARAMÈTRE PREVIEW
    $preview = $_GET['preview'] ?? 'false';
    if ($preview === 'true') {
        echo json_encode([
            'success' => true,
            'message' => 'API Déchets disponible',
            'user' => $user['nom'] . ' ' . $user['prenom'],
            'timestamp' => date('Y-m-d H:i:s'),
            'available_formats' => ['json', 'csv', 'excel'],
            'status' => 'ready'
        ]);
        exit;
    }
    
    // Paramètres d'export
    $format = $_GET['format'] ?? 'excel';
    $include_details = $_GET['include_details'] ?? 'true';
    $include_photos = $_GET['include_photos'] ?? 'false';
    $site_id = $_GET['site_id'] ?? null;
    $date_debut = $_GET['date_debut'] ?? null;
    $date_fin = $_GET['date_fin'] ?? null;
    $statut = $_GET['statut'] ?? null;
    
    // Construire la requête avec filtres
    $where_conditions = ['1=1'];
    $params = [];
    
    // Filtre par site si nécessaire
    if ($site_id) {
        $where_conditions[] = 'rd.site_id = ?';
        $params[] = $site_id;
    }
    
    // Filtre par date
    if ($date_debut) {
        $where_conditions[] = 'rd.date_releve >= ?';
        $params[] = $date_debut;
    }
    if ($date_fin) {
        $where_conditions[] = 'rd.date_releve <= ?';
        $params[] = $date_fin;
    }
    
    // Filtre par statut
    if ($statut && $statut !== 'tous') {
        $where_conditions[] = 'rd.statut = ?';
        $params[] = $statut;
    }
    
    $where_clause = implode(' AND ', $where_conditions);
    
    // Requête principale pour les relevés de déchets
    $query = "
        SELECT 
            rd.id,
            rd.code_referent,
            rd.date_releve,
            rd.heure_debut,
            rd.latitude_debut,
            rd.longitude_debut,
            rd.latitude_fin,
            rd.longitude_fin,
            rd.orientation_plage,
            rd.courant_dominant,
            rd.vent_dominant,
            rd.statut,
            rd.created_at,
            rd.updated_at,
            COALESCE(CONCAT(u.prenom, ' ', u.nom), 'N/A') as referent_nom,
            COALESCE(u.email, '') as referent_email,
            COALESCE(u.telephone, '') as referent_telephone,
            COALESCE(s.nom_site, 'Site inconnu') as nom_site,
            COALESCE(s.region, '') as region,
            s.latitude as site_latitude,
            s.longitude as site_longitude
        FROM releves_dechets rd
        LEFT JOIN users u ON rd.user_id = u.id
        LEFT JOIN sites s ON rd.site_id = s.id
        WHERE {$where_clause}
        ORDER BY rd.date_releve DESC, rd.id DESC
        LIMIT 1000
    ";
    
    $stmt = $pdo->prepare($query);
    $stmt->execute($params);
    $releves = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    $export_data = [
        'releves' => [],
        'evenements_extremes' => [],
        'dechets_detail' => [],
        'categories_statistiques' => [],
        'metadata' => [
            'export_date' => date('Y-m-d H:i:s'),
            'exported_by' => $user['nom'] . ' ' . $user['prenom'],
            'total_releves' => count($releves),
            'format' => $format,
            'include_photos' => $include_photos === 'true',
            'filters' => [
                'site_id' => $site_id,
                'date_debut' => $date_debut,
                'date_fin' => $date_fin,
                'statut' => $statut
            ]
        ]
    ];
    
    // Référentiels pour les codes
    $orientations = [
        '01' => 'Nord', '02' => 'Nord-Est', '03' => 'Est', '04' => 'Sud-Est',
        '05' => 'Sud', '06' => 'Sud-Ouest', '07' => 'Ouest', '08' => 'Nord-Ouest'
    ];
    
    $sources_pollution = [
        '1' => 'Alimentaire', '2' => 'Tabac', '3' => 'Pêche',
        '4' => 'Conchyliculture', '5' => 'Sanitaire', '6' => 'Autres'
    ];
    
    $categories_dechets = [
        'PL' => 'Plastique', 'CA' => 'Carton/Papier', 'TX' => 'Textile',
        'ME' => 'Métal', 'VE' => 'Verre', 'BO' => 'Bois', 'AU' => 'Autre'
    ];
    
    foreach ($releves as $releve) {
        // Données principales du relevé
        $export_data['releves'][] = [
            'id' => $releve['id'],
            'code_referent' => $releve['code_referent'],
            'date_releve' => $releve['date_releve'],
            'heure_debut' => $releve['heure_debut'],
            'latitude_debut' => $releve['latitude_debut'],
            'longitude_debut' => $releve['longitude_debut'],
            'latitude_fin' => $releve['latitude_fin'],
            'longitude_fin' => $releve['longitude_fin'],
            'orientation_plage' => $releve['orientation_plage'],
            'orientation_nom' => $orientations[$releve['orientation_plage']] ?? 'Inconnu',
            'courant_dominant' => $releve['courant_dominant'],
            'courant_nom' => $orientations[$releve['courant_dominant']] ?? 'Inconnu',
            'vent_dominant' => $releve['vent_dominant'],
            'vent_nom' => $orientations[$releve['vent_dominant']] ?? 'Inconnu',
            'statut' => $releve['statut'],
            'referent_nom' => $releve['referent_nom'],
            'referent_email' => $releve['referent_email'],
            'referent_telephone' => $releve['referent_telephone'],
            'nom_site' => $releve['nom_site'],
            'region' => $releve['region'],
            'site_latitude' => $releve['site_latitude'],
            'site_longitude' => $releve['site_longitude'],
            'created_at' => $releve['created_at'],
            'updated_at' => $releve['updated_at']
        ];
        
        if ($include_details === 'true') {
            try {
                // Récupérer les événements extrêmes
                $events_query = "SELECT * FROM evenements_extremes_dechets WHERE releve_id = ?";
                $events_stmt = $pdo->prepare($events_query);
                $events_stmt->execute([$releve['id']]);
                $events = $events_stmt->fetchAll(PDO::FETCH_ASSOC);
                
                foreach ($events as $event) {
                    $export_data['evenements_extremes'][] = [
                        'releve_id' => $releve['id'],
                        'code_referent' => $releve['code_referent'],
                        'evenement_code' => $event['evenement_code'] ?? '',
                        'autre_evenement' => $event['autre_evenement'] ?? ''
                    ];
                }
                
                // Récupérer les détails des déchets
                $dechets_query = "
                    SELECT 
                        dd.*,
                        CASE 
                            WHEN dd.photo IS NOT NULL AND LENGTH(dd.photo) > 0 THEN 1 
                            ELSE 0 
                        END as has_photo
                    FROM dechets_detail dd 
                    WHERE dd.releve_id = ? 
                    ORDER BY dd.id
                ";
                $dechets_stmt = $pdo->prepare($dechets_query);
                $dechets_stmt->execute([$releve['id']]);
                $dechets = $dechets_stmt->fetchAll(PDO::FETCH_ASSOC);
                
                foreach ($dechets as $dechet) {
                    $dechet_data = [
                        'releve_id' => $releve['id'],
                        'code_referent' => $releve['code_referent'],
                        'detail_id' => $dechet['id'],
                        'categorie' => $dechet['categorie'] ?? '',
                        'categorie_nom' => $categories_dechets[$dechet['categorie']] ?? 'Inconnu',
                        'nombre_articles' => $dechet['nombre_articles'] ?? 0,
                        'poids' => $dechet['poids'] ?? 0,
                        'source_pollution' => $dechet['source_pollution'] ?? '',
                        'source_nom' => $sources_pollution[$dechet['source_pollution']] ?? 'Inconnu',
                        'has_photo' => $dechet['has_photo'],
                        'created_at' => $dechet['created_at'] ?? ''
                    ];
                    
                    // Inclure la photo si demandé
                    if ($include_photos === 'true' && isset($dechet['photo']) && $dechet['photo']) {
                        $dechet_data['photo_base64'] = $dechet['photo'];
                    }
                    
                    $export_data['dechets_detail'][] = $dechet_data;
                }
            } catch (Exception $detailsError) {
                error_log("Erreur détails releve {$releve['id']}: " . $detailsError->getMessage());
            }
        }
    }
    
    // Générer des statistiques par catégorie
    if ($include_details === 'true') {
        try {
            $stats_query = "
                SELECT 
                    dd.categorie,
                    COUNT(*) as nombre_releves,
                    SUM(dd.nombre_articles) as total_articles,
                    SUM(dd.poids) as total_poids,
                    AVG(dd.poids) as poids_moyen,
                    COUNT(CASE WHEN dd.photo IS NOT NULL AND LENGTH(dd.photo) > 0 THEN 1 END) as nombre_photos
                FROM dechets_detail dd
                INNER JOIN releves_dechets rd ON dd.releve_id = rd.id
                WHERE {$where_clause}
                GROUP BY dd.categorie
                ORDER BY total_poids DESC
            ";
            
            $stats_stmt = $pdo->prepare($stats_query);
            $stats_stmt->execute($params);
            $stats = $stats_stmt->fetchAll(PDO::FETCH_ASSOC);
            
            foreach ($stats as $stat) {
                $export_data['categories_statistiques'][] = [
                    'categorie' => $stat['categorie'],
                    'categorie_nom' => $categories_dechets[$stat['categorie']] ?? 'Inconnu',
                    'nombre_releves' => $stat['nombre_releves'],
                    'total_articles' => $stat['total_articles'],
                    'total_poids' => round($stat['total_poids'], 2),
                    'poids_moyen' => round($stat['poids_moyen'], 2),
                    'nombre_photos' => $stat['nombre_photos']
                ];
            }
        } catch (Exception $statsError) {
            error_log("Erreur statistiques: " . $statsError->getMessage());
        }
    }
    
    // Générer le fichier selon le format demandé
    switch ($format) {
        case 'excel':
            generateExcelExportDechets($export_data);
            break;
        case 'csv':
            generateCSVExportDechets($export_data);
            break;
        case 'json':
            generateJSONExportDechets($export_data);
            break;
        default:
            throw new Exception('Format d\'export non supporté');
    }
    
} catch (Exception $e) {
    error_log("Erreur export déchets: " . $e->getMessage());
    error_log("Stack trace: " . $e->getTraceAsString());
    
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Erreur lors de l\'export: ' . $e->getMessage(),
        'debug' => [
            'file' => $e->getFile(),
            'line' => $e->getLine(),
            'user_role' => $user['role'] ?? 'unknown'
        ]
    ]);
}

function generateExcelExportDechets($data) {
    // Vérifier si PhpSpreadsheet est disponible
    $vendorPaths = [
        __DIR__ . '/../vendor/autoload.php',
        __DIR__ . '/../../vendor/autoload.php',
        __DIR__ . '/../../../vendor/autoload.php'
    ];
    
    $vendorFound = false;
    foreach ($vendorPaths as $path) {
        if (file_exists($path)) {
            require_once $path;
            $vendorFound = true;
            break;
        }
    }
    
    if (!$vendorFound) {
        // Fallback vers CSV si PhpSpreadsheet non disponible
        generateCSVExportDechets($data);
        return;
    }
    
    try {
        $spreadsheet = new \PhpOffice\PhpSpreadsheet\Spreadsheet();
        
        // Feuille 1: Métadonnées
        $sheet = $spreadsheet->getActiveSheet();
        $sheet->setTitle('Métadonnées');
        
        $sheet->setCellValue('A1', 'Export des Relevés de Déchets');
        $sheet->setCellValue('A2', 'Date d\'export: ' . $data['metadata']['export_date']);
        $sheet->setCellValue('A3', 'Exporté par: ' . $data['metadata']['exported_by']);
        $sheet->setCellValue('A4', 'Total relevés: ' . $data['metadata']['total_releves']);
        $sheet->setCellValue('A5', 'Photos incluses: ' . ($data['metadata']['include_photos'] ? 'Oui' : 'Non'));
        
        // Style pour le titre
        $sheet->getStyle('A1')->getFont()->setBold(true)->setSize(16);
        $sheet->getStyle('A1:A5')->getFont()->setBold(true);
        
        // Feuille 2: Relevés principaux
        $releveSheet = $spreadsheet->createSheet();
        $releveSheet->setTitle('Relevés');
        
        // En-têtes
        $headers = [
            'ID', 'Code Référent', 'Date Relevé', 'Heure Début',
            'Lat. Début', 'Long. Début', 'Lat. Fin', 'Long. Fin',
            'Orientation Plage', 'Courant Dominant', 'Vent Dominant',
            'Statut', 'Référent', 'Email Référent', 'Téléphone Référent',
            'Site', 'Région', 'Lat. Site', 'Long. Site',
            'Créé le', 'Modifié le'
        ];
        
        $col = 'A';
        foreach ($headers as $header) {
            $releveSheet->setCellValue($col . '1', $header);
            $col++;
        }
        
        // Style des en-têtes
        $headerRange = 'A1:' . chr(ord('A') + count($headers) - 1) . '1';
        $releveSheet->getStyle($headerRange)->applyFromArray([
            'font' => ['bold' => true, 'color' => ['rgb' => 'FFFFFF']],
            'fill' => [
                'fillType' => \PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                'startColor' => ['rgb' => 'F39C12']
            ],
            'borders' => [
                'allBorders' => ['borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN]
            ]
        ]);
        
        // Données des relevés
        $row = 2;
        foreach ($data['releves'] as $releve) {
            $releveSheet->setCellValue('A' . $row, $releve['id']);
            $releveSheet->setCellValue('B' . $row, $releve['code_referent']);
            $releveSheet->setCellValue('C' . $row, $releve['date_releve']);
            $releveSheet->setCellValue('D' . $row, $releve['heure_debut']);
            $releveSheet->setCellValue('E' . $row, $releve['latitude_debut']);
            $releveSheet->setCellValue('F' . $row, $releve['longitude_debut']);
            $releveSheet->setCellValue('G' . $row, $releve['latitude_fin']);
            $releveSheet->setCellValue('H' . $row, $releve['longitude_fin']);
            $releveSheet->setCellValue('I' . $row, $releve['orientation_nom']);
            $releveSheet->setCellValue('J' . $row, $releve['courant_nom']);
            $releveSheet->setCellValue('K' . $row, $releve['vent_nom']);
            $releveSheet->setCellValue('L' . $row, $releve['statut']);
            $releveSheet->setCellValue('M' . $row, $releve['referent_nom']);
            $releveSheet->setCellValue('N' . $row, $releve['referent_email']);
            $releveSheet->setCellValue('O' . $row, $releve['referent_telephone']);
            $releveSheet->setCellValue('P' . $row, $releve['nom_site']);
            $releveSheet->setCellValue('Q' . $row, $releve['region']);
            $releveSheet->setCellValue('R' . $row, $releve['site_latitude']);
            $releveSheet->setCellValue('S' . $row, $releve['site_longitude']);
            $releveSheet->setCellValue('T' . $row, $releve['created_at']);
            $releveSheet->setCellValue('U' . $row, $releve['updated_at']);
            $row++;
        }
        
        // Auto-ajuster les colonnes
        foreach (range('A', 'U') as $col) {
            $releveSheet->getColumnDimension($col)->setAutoSize(true);
        }
        
        // Sélectionner la première feuille
        $spreadsheet->setActiveSheetIndex(0);
        
        // Générer le fichier
        $filename = 'export_dechets_' . date('Y-m-d_H-i-s') . '.xlsx';
        
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment; filename="' . $filename . '"');
        header('Cache-Control: max-age=0');
        
        $writer = new \PhpOffice\PhpSpreadsheet\Writer\Xlsx($spreadsheet);
        $writer->save('php://output');
        exit;
        
    } catch (Exception $e) {
        error_log("Erreur Excel déchets: " . $e->getMessage());
        generateCSVExportDechets($data);
    }
}

function generateCSVExportDechets($data) {
    $filename = 'export_dechets_' . date('Y-m-d_H-i-s') . '.csv';
    
    header('Content-Type: text/csv; charset=utf-8');
    header('Content-Disposition: attachment; filename="' . $filename . '"');
    header('Cache-Control: max-age=0');
    
    $output = fopen('php://output', 'w');
    
    // BOM pour Excel
    fprintf($output, chr(0xEF).chr(0xBB).chr(0xBF));
    
    // En-têtes
    $headers = [
        'ID', 'Code Référent', 'Date Relevé', 'Heure Début',
        'Lat. Début', 'Long. Début', 'Lat. Fin', 'Long. Fin',
        'Orientation Plage', 'Courant Dominant', 'Vent Dominant',
        'Statut', 'Référent', 'Email Référent', 'Téléphone Référent',
        'Site', 'Région', 'Créé le', 'Modifié le'
    ];
    
    fputcsv($output, $headers, ';');
    
    // Données
    foreach ($data['releves'] as $releve) {
        $row = [
            $releve['id'],
            $releve['code_referent'],
            $releve['date_releve'],
            $releve['heure_debut'],
            $releve['latitude_debut'],
            $releve['longitude_debut'],
            $releve['latitude_fin'],
            $releve['longitude_fin'],
            $releve['orientation_nom'],
            $releve['courant_nom'],
            $releve['vent_nom'],
            $releve['statut'],
            $releve['referent_nom'],
            $releve['referent_email'],
            $releve['referent_telephone'],
            $releve['nom_site'],
            $releve['region'],
            $releve['created_at'],
            $releve['updated_at']
        ];
        fputcsv($output, $row, ';');
    }
    
    fclose($output);
    exit;
}

function generateJSONExportDechets($data) {
    $filename = 'export_dechets_' . date('Y-m-d_H-i-s') . '.json';
    
    header('Content-Type: application/json; charset=utf-8');
    header('Content-Disposition: attachment; filename="' . $filename . '"');
    header('Cache-Control: max-age=0');
    
    echo json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
    exit;
}
?>