<?php
// api/sites/delete.php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: DELETE, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

if ($_SERVER['REQUEST_METHOD'] !== 'DELETE') {
    http_response_code(405);
    echo json_encode(['success' => false, 'message' => 'Méthode non autorisée']);
    exit();
}

try {
    // Configuration BDD
    $host = 'localhost';
    $dbname = 'softdgid_toto';
    $username = 'softdgid_pape';
    $password = 'P@sser0101';
    
    $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8mb4", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    // Récupérer l'ID
    $site_id = null;
    if (isset($_GET['id'])) {
        $site_id = (int)$_GET['id'];
    } else {
        $input = file_get_contents('php://input');
        $data = json_decode($input, true);
        $site_id = isset($data['id']) ? (int)$data['id'] : null;
    }
    
    if (!$site_id) {
        throw new Exception('ID site manquant');
    }
    
    // Vérifier que le site existe
    $stmt_check = $pdo->prepare("SELECT id, nom_site FROM sites WHERE id = ?");
    $stmt_check->execute([$site_id]);
    $site = $stmt_check->fetch();
    
    if (!$site) {
        throw new Exception('Site non trouvé');
    }
    
    // Vérifier s'il y a des données liées
    $stmt_users = $pdo->prepare("SELECT COUNT(*) as count FROM utilisateurs WHERE site_id = ?");
    $stmt_users->execute([$site_id]);
    $users_count = $stmt_users->fetch()['count'];
    
    $stmt_profils = $pdo->prepare("SELECT COUNT(*) as count FROM profils_topographiques WHERE site_id = ?");
    $stmt_profils->execute([$site_id]);
    $profils_count = $stmt_profils->fetch()['count'];
    
    $stmt_dechets = $pdo->prepare("SELECT COUNT(*) as count FROM releves_dechets WHERE site_id = ?");
    $stmt_dechets->execute([$site_id]);
    $dechets_count = $stmt_dechets->fetch()['count'];
    
    $total_linked = $users_count + $profils_count + $dechets_count;
    
    if ($total_linked > 0) {
        throw new Exception("Impossible de supprimer le site '{$site['nom_site']}'. Il est lié à $users_count utilisateur(s), $profils_count profil(s) et $dechets_count relevé(s) de déchets.");
    }
    
    // Supprimer le site
    $stmt_delete = $pdo->prepare("DELETE FROM sites WHERE id = ?");
    $result = $stmt_delete->execute([$site_id]);
    
    if ($result) {
        echo json_encode([
            'success' => true,
            'message' => "Site '{$site['nom_site']}' supprimé avec succès"
        ]);
    } else {
        throw new Exception('Erreur lors de la suppression');
    }
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Erreur: ' . $e->getMessage()
    ]);
}
?>