<?php
// api/sites/update.php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: PUT, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

if ($_SERVER['REQUEST_METHOD'] !== 'PUT') {
    http_response_code(405);
    echo json_encode(['success' => false, 'message' => 'Méthode non autorisée']);
    exit();
}

try {
    // Configuration BDD
    $host = 'localhost';
    $dbname = 'softdgid_toto';
    $username = 'softdgid_pape';
    $password = 'P@sser0101';
    
    $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8mb4", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    // Récupérer les données
    $input = file_get_contents('php://input');
    $data = json_decode($input, true);
    
    if (!$data || !isset($data['id'])) {
        throw new Exception('Données invalides ou ID manquant');
    }
    
    $site_id = (int)$data['id'];
    
    // Vérifier que le site existe
    $stmt_check = $pdo->prepare("SELECT id FROM sites WHERE id = ?");
    $stmt_check->execute([$site_id]);
    if (!$stmt_check->fetch()) {
        throw new Exception('Site non trouvé');
    }
    
    // Mettre à jour le site
    $sql = "UPDATE sites SET 
        nom_site = :nom_site,
        region = :region,
        latitude = :latitude,
        longitude = :longitude
    WHERE id = :id";
    
    $params = [
        ':id' => $site_id,
        ':nom_site' => $data['nom_site'] ?? '',
        ':region' => $data['region'] ?? '',
        ':latitude' => !empty($data['latitude']) ? (float)$data['latitude'] : null,
        ':longitude' => !empty($data['longitude']) ? (float)$data['longitude'] : null
    ];
    
    $stmt = $pdo->prepare($sql);
    $result = $stmt->execute($params);
    
    if ($result) {
        echo json_encode([
            'success' => true,
            'message' => 'Site mis à jour avec succès',
            'data' => ['id' => $site_id]
        ]);
    } else {
        throw new Exception('Erreur lors de la mise à jour');
    }
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Erreur: ' . $e->getMessage()
    ]);
}
?>