<?php
// api/users/delete.php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: DELETE, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

if ($_SERVER['REQUEST_METHOD'] !== 'DELETE') {
    http_response_code(405);
    echo json_encode(['success' => false, 'message' => 'Méthode non autorisée']);
    exit();
}

try {
    // Configuration BDD
    $host = 'localhost';
    $dbname = 'softdgid_toto';
    $username = 'softdgid_pape';
    $password = 'P@sser0101';
    
    $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8mb4", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    // Récupérer l'ID depuis l'URL ou le body
    $user_id = null;
    if (isset($_GET['id'])) {
        $user_id = (int)$_GET['id'];
    } else {
        $input = file_get_contents('php://input');
        $data = json_decode($input, true);
        $user_id = isset($data['id']) ? (int)$data['id'] : null;
    }
    
    if (!$user_id) {
        throw new Exception('ID utilisateur manquant');
    }
    
    // Vérifier que l'utilisateur existe et n'est pas admin
    $stmt_check = $pdo->prepare("SELECT id, role FROM utilisateurs WHERE id = ?");
    $stmt_check->execute([$user_id]);
    $user = $stmt_check->fetch();
    
    if (!$user) {
        throw new Exception('Utilisateur non trouvé');
    }
    
    if ($user['role'] === 'admin') {
        throw new Exception('Impossible de supprimer un administrateur');
    }
    
    // Commencer une transaction
    $pdo->beginTransaction();
    
    try {
        // Vérifier s'il y a des données liées
        $stmt_profils = $pdo->prepare("SELECT COUNT(*) as count FROM profils_topographiques WHERE utilisateur_id = ?");
        $stmt_profils->execute([$user_id]);
        $profils_count = $stmt_profils->fetch()['count'];
        
        $stmt_dechets = $pdo->prepare("SELECT COUNT(*) as count FROM releves_dechets WHERE utilisateur_id = ?");
        $stmt_dechets->execute([$user_id]);
        $dechets_count = $stmt_dechets->fetch()['count'];
        
        if ($profils_count > 0 || $dechets_count > 0) {
            // Désactiver au lieu de supprimer
            $stmt_disable = $pdo->prepare("UPDATE utilisateurs SET actif = 0 WHERE id = ?");
            $result = $stmt_disable->execute([$user_id]);
            
            $pdo->commit();
            
            echo json_encode([
                'success' => true,
                'message' => "Utilisateur désactivé (il a $profils_count profils et $dechets_count relevés de déchets)",
                'action' => 'disabled'
            ]);
        } else {
            // Supprimer définitivement
            $stmt_delete = $pdo->prepare("DELETE FROM utilisateurs WHERE id = ?");
            $result = $stmt_delete->execute([$user_id]);
            
            $pdo->commit();
            
            echo json_encode([
                'success' => true,
                'message' => 'Utilisateur supprimé avec succès',
                'action' => 'deleted'
            ]);
        }
        
    } catch (Exception $e) {
        $pdo->rollback();
        throw $e;
    }
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Erreur: ' . $e->getMessage()
    ]);
}
?>