<?php
header('Content-Type: application/json');
require_once '../config/database.php';

try {
    // Utiliser votre classe Database
    $database = new Database();
    
    // Test de connexion
    $connectionInfo = $database->testConnection();
    $pdo = $database->getConnection();
    
    if (!$pdo || !$connectionInfo) {
        throw new Exception('Impossible de se connecter à la base de données');
    }
    
    // Test si la table utilisateurs existe
    $tableCheck = $pdo->query("SHOW TABLES LIKE 'utilisateurs'");
    $tableExists = $tableCheck->rowCount() > 0;
    
    if (!$tableExists) {
        echo json_encode([
            'success' => false,
            'message' => 'Table utilisateurs n\'existe pas',
            'solution' => 'La table utilisateurs doit être créée',
            'connection_info' => $connectionInfo
        ]);
        exit;
    }
    
    // Compter les utilisateurs
    $countStmt = $pdo->query("SELECT COUNT(*) as total FROM utilisateurs");
    $count = $countStmt->fetch(PDO::FETCH_ASSOC)['total'];
    
    // Récupérer quelques utilisateurs avec leurs sites
    $usersStmt = $pdo->query("
        SELECT u.id, u.nom, u.prenom, u.email, u.role, u.actif,
               s.nom_site, s.region
        FROM utilisateurs u 
        LEFT JOIN sites s ON u.site_id = s.id 
        LIMIT 5
    ");
    $users = $usersStmt->fetchAll(PDO::FETCH_ASSOC);
    
    // Compter les sites
    $sitesStmt = $pdo->query("SELECT COUNT(*) as total FROM sites");
    $sitesCount = $sitesStmt->fetch(PDO::FETCH_ASSOC)['total'];
    
    // Récupérer les sites
    $sitesListStmt = $pdo->query("SELECT id, nom_site, region FROM sites ORDER BY nom_site");
    $sitesList = $sitesListStmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo json_encode([
        'success' => true,
        'message' => 'Test réussi - Connexion Database Class',
        'connection_info' => $connectionInfo,
        'database_connection' => 'OK',
        'table_utilisateurs' => true,
        'table_sites' => true,
        'total_users' => $count,
        'total_sites' => $sitesCount,
        'sample_users' => $users,
        'sites_list' => $sitesList,
        'structure_info' => [
            'table_utilisateurs' => 'Utilisateurs avec rôles: controleur, referent, superviseur, admin',
            'table_sites' => 'Sites côtiers avec coordonnées GPS',
            'password_encryption' => 'MD5 (détecté dans la structure existante)',
            'database_class' => 'Utilisation de la classe Database avec connexions alternatives'
        ],
        'timestamp' => date('Y-m-d H:i:s')
    ]);
    
} catch (PDOException $e) {
    echo json_encode([
        'success' => false,
        'message' => 'Erreur de base de données: ' . $e->getMessage(),
        'error_code' => $e->getCode(),
        'timestamp' => date('Y-m-d H:i:s')
    ]);
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'message' => 'Erreur: ' . $e->getMessage(),
        'timestamp' => date('Y-m-d H:i:s')
    ]);
}
?><?php
header('Content-Type: application/json');
require_once '../config/database.php';

try {
    // Test de connexion à la base de données
    $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    // Test si la table utilisateurs existe
    $tableCheck = $pdo->query("SHOW TABLES LIKE 'utilisateurs'");
    $tableExists = $tableCheck->rowCount() > 0;
    
    if (!$tableExists) {
        echo json_encode([
            'success' => false,
            'message' => 'Table utilisateurs n\'existe pas',
            'solution' => 'La table utilisateurs doit être créée'
        ]);
        exit;
    }
    
    // Compter les utilisateurs
    $countStmt = $pdo->query("SELECT COUNT(*) as total FROM utilisateurs");
    $count = $countStmt->fetch(PDO::FETCH_ASSOC)['total'];
    
    // Récupérer quelques utilisateurs avec leurs sites
    $usersStmt = $pdo->query("
        SELECT u.id, u.nom, u.prenom, u.email, u.role, u.actif,
               s.nom_site, s.region
        FROM utilisateurs u 
        LEFT JOIN sites s ON u.site_id = s.id 
        LIMIT 5
    ");
    $users = $usersStmt->fetchAll(PDO::FETCH_ASSOC);
    
    // Compter les sites
    $sitesStmt = $pdo->query("SELECT COUNT(*) as total FROM sites");
    $sitesCount = $sitesStmt->fetch(PDO::FETCH_ASSOC)['total'];
    
    echo json_encode([
        'success' => true,
        'message' => 'Test réussi',
        'database_connection' => 'OK',
        'table_utilisateurs' => true,
        'table_sites' => true,
        'total_users' => $count,
        'total_sites' => $sitesCount,
        'sample_users' => $users,
        'structure_info' => [
            'table_utilisateurs' => 'Utilisateurs avec rôles: controleur, referent, superviseur, admin',
            'table_sites' => 'Sites côtiers avec coordonnées GPS',
            'password_encryption' => 'MD5 (détecté dans la structure existante)'
        ]
    ]);
    
} catch (PDOException $e) {
    echo json_encode([
        'success' => false,
        'message' => 'Erreur de base de données: ' . $e->getMessage()
    ]);
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'message' => 'Erreur: ' . $e->getMessage()
    ]);
}
?>