<?php
// api/users/update.php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: PUT, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

if ($_SERVER['REQUEST_METHOD'] !== 'PUT') {
    http_response_code(405);
    echo json_encode(['success' => false, 'message' => 'Méthode non autorisée']);
    exit();
}

try {
    // Configuration BDD
    $host = 'localhost';
    $dbname = 'softdgid_toto';
    $username = 'softdgid_pape';
    $password = 'P@sser0101';
    
    $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8mb4", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    // Récupérer les données
    $input = file_get_contents('php://input');
    $data = json_decode($input, true);
    
    if (!$data || !isset($data['id'])) {
        throw new Exception('Données invalides ou ID manquant');
    }
    
    $user_id = (int)$data['id'];
    
    // Vérifier que l'utilisateur existe
    $stmt_check = $pdo->prepare("SELECT id FROM utilisateurs WHERE id = ?");
    $stmt_check->execute([$user_id]);
    if (!$stmt_check->fetch()) {
        throw new Exception('Utilisateur non trouvé');
    }
    
    // Préparer la requête de mise à jour
    $sql = "UPDATE utilisateurs SET 
        nom = :nom,
        prenom = :prenom,
        email = :email,
        telephone = :telephone,
        role = :role,
        site_id = :site_id,
        actif = :actif";
    
    $params = [
        ':nom' => $data['nom'] ?? '',
        ':prenom' => $data['prenom'] ?? '',
        ':email' => $data['email'] ?? '',
        ':telephone' => $data['telephone'] ?? '',
        ':role' => $data['role'] ?? 'referent',
        ':site_id' => !empty($data['site_id']) ? (int)$data['site_id'] : null,
        ':actif' => isset($data['actif']) ? (int)$data['actif'] : 1
    ];
    
    // Ajouter le mot de passe s'il est fourni
    if (!empty($data['mot_de_passe'])) {
        $sql .= ", mot_de_passe = :mot_de_passe";
        $params[':mot_de_passe'] = md5($data['mot_de_passe']);
    }
    
    $sql .= " WHERE id = :id";
    $params[':id'] = $user_id;
    
    $stmt = $pdo->prepare($sql);
    $result = $stmt->execute($params);
    
    if ($result) {
        echo json_encode([
            'success' => true,
            'message' => 'Utilisateur mis à jour avec succès',
            'data' => ['id' => $user_id]
        ]);
    } else {
        throw new Exception('Erreur lors de la mise à jour');
    }
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Erreur: ' . $e->getMessage()
    ]);
}
?>